import os

# List of all HTML files in screens
files_to_update = [
    'analytics.html',
    'driver-engagement.html',
    'driver-scorecards.html',
    'fleet-utilization.html',
    'performance-overview.html',
    'settings.html',
    'users.html',
    'violation-detail-log.html',
    'violations-summary.html',
    'repeat-offenders.html'
]

screens_dir = r'c:\Users\MohamedHassa_7bh37l6\Desktop\RTA-Dashboard\dashboard-app\screens'

# CSS link to add
css_links_to_add = [
    '    <link rel="stylesheet" href="../css/sidebar-fixes.css">',
    '    <link rel="stylesheet" href="../css/table-color-fixes.css">'
]

for filename in files_to_update:
    filepath = os.path.join(screens_dir, filename)
    
    if not os.path.exists(filepath):
        print(f"Skipping {filename} - file not found")
        continue
    
    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            content = f.read()
        
        updated = False
        # Add CSS links after multilang.css
        if '<link rel="stylesheet" href="../css/multilang.css">' in content:
            # Use a placeholder to avoid replacing multiple times inside the loop
            placeholder = '<link rel="stylesheet" href="../css/multilang.css">'
            new_content = placeholder
            for css_link in css_links_to_add:
                if css_link.split('/')[-1].strip('">') not in content:
                    new_content += '\n' + css_link
                    updated = True
        
            content = content.replace(placeholder, new_content)
            
            # Write back
            with open(filepath, 'w', encoding='utf-8') as f:
                f.write(content)
            
            print(f"✓ Updated {filename}")
        else:
            if not updated:
                print(f"Skipping {filename} - already up to date or multilang.css not found.")
            
        
    except Exception as e:
        print(f"✗ Error updating {filename}: {str(e)}")

print("\n✅ CSS links update process complete for all pages!")
