// Enhanced Sidebar Loader
(function() {
    'use strict';
    
    // Load sidebar automatically
    window.addEventListener('DOMContentLoaded', function() {
        loadEnhancedSidebar();
    });
    
    function loadEnhancedSidebar() {
        // Check if we're in root or screens directory
        const isInScreens = window.location.pathname.includes('/screens/');
        const sidebarPath = isInScreens ? 'https://otaengine.com/RTADash/components/enhanced-sidebar.html' : 'https://otaengine.com/RTADash/components/enhanced-sidebar.html';
        
        // Create sidebar container if it doesn't exist
        let sidebarContainer = document.getElementById('enhancedSidebarContainer');
        if (!sidebarContainer) {
            sidebarContainer = document.createElement('div');
            sidebarContainer.id = 'enhancedSidebarContainer';
            document.body.insertBefore(sidebarContainer, document.body.firstChild);
        }
        
        // Load sidebar HTML
        fetch(sidebarPath)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Failed to load sidebar');
                }
                return response.text();
            })
            .then(html => {
                sidebarContainer.innerHTML = html;
                // mark body for internal pages so we can apply page-specific styles
                if (isInScreens) {
                    document.body.classList.add('internal-page');
                } else {
                    document.body.classList.remove('internal-page');
                }
                initializeSidebar();
            })
            .catch(error => {
                console.error('Error loading enhanced sidebar:', error);
            });
    }
    
    function initializeSidebar() {
        // Add active class to current page menu item
        const currentPage = getCurrentPage();
        const menuItems = document.querySelectorAll('.menu-item[data-page]');
        
        menuItems.forEach(item => {
            if (item.dataset.page === currentPage) {
                item.classList.add('active');
            }
        });
        
        // Update main content margin
        updateContentMargin();
        
        // Listen for sidebar toggle
        const sidebar = document.getElementById('sidebarEnhanced');
        if (sidebar) {
            const observer = new MutationObserver(function() {
                updateContentMargin();
            });
            observer.observe(sidebar, { attributes: true, attributeFilter: ['class'] });
        }
    }
    
    function getCurrentPage() {
        const path = window.location.pathname;
        const page = path.split('/').pop().replace('.html', '');
        
        // Handle index pages
        if (page === 'index-new' || page === 'index-en' || page === 'index-ar' || page === '') {
            return 'overview';
        }
        
        return page;
    }
    
    function updateContentMargin() {
        const sidebar = document.getElementById('sidebarEnhanced');
        const mainContent = document.querySelector('.main-content');
        
        if (sidebar && mainContent) {
            if (sidebar.classList.contains('collapsed')) {
                mainContent.style.marginLeft = '80px';
            } else {
                mainContent.style.marginLeft = '280px';
            }
        }
    }
    
    // Make functions globally available
    window.toggleEnhancedSidebar = function() {
        const sidebar = document.getElementById('sidebarEnhanced');
        if (sidebar) {
            sidebar.classList.toggle('collapsed');
        }
    };
    
    window.generateCustomReport = function() {
        alert('Opening custom report generator...');
    };
})();
