import os
import re

# List of files to update
files_to_update = [
    'analytics.html',
    'driver-engagement.html',
    'driver-scorecards.html',
    'fleet-utilization.html',
    'performance-overview.html',
    'settings.html',
    'users.html',
    'violation-detail-log.html'
]

screens_dir = r'c:\Users\MohamedHassa_7bh37l6\Desktop\RTA-Dashboard\dashboard-app\screens'

# Code to add
sidebar_script = '    <script src="../js/sidebar-loader.js"></script>'
sidebar_style = '''    <style>
        .main-content {
            margin-left: 280px;
            transition: margin-left 0.3s ease;
        }
    </style>'''

for filename in files_to_update:
    filepath = os.path.join(screens_dir, filename)
    
    if not os.path.exists(filepath):
        print(f"Skipping {filename} - file not found")
        continue
    
    try:
        with open(filepath, 'r', encoding='utf-8') as f:
            content = f.read()
        
        # Check if already updated
        if 'sidebar-loader.js' in content:
            print(f"Skipping {filename} - already updated")
            continue
        
        # Add script after last script tag in head
        if '<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>' in content:
            content = content.replace(
                '<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>',
                '<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>\n' + sidebar_script
            )
        
        # Add style before </head>
        if '</head>' in content:
            content = content.replace(
                '</head>',
                sidebar_style + '\n</head>'
            )
        
        # Write back
        with open(filepath, 'w', encoding='utf-8') as f:
            f.write(content)
        
        print(f"✓ Updated {filename}")
        
    except Exception as e:
        print(f"✗ Error updating {filename}: {str(e)}")

print("\n✅ Update complete!")
